/*
 * Decompiled with CFR 0.152.
 */
package com.st0x0ef.stellaris.common.utils;

import com.st0x0ef.stellaris.common.data.planets.Planet;
import com.st0x0ef.stellaris.common.data.planets.StellarisData;
import com.st0x0ef.stellaris.common.menus.GalaxyMenu;
import com.st0x0ef.stellaris.common.menus.PlanetSelectionMenu;
import com.st0x0ef.stellaris.common.menus.TabletMenu;
import com.st0x0ef.stellaris.common.menus.WaitMenu;
import com.st0x0ef.stellaris.common.oxygen.GlobalOxygenManager;
import com.st0x0ef.stellaris.common.utils.ResourceLocationUtils;
import com.st0x0ef.stellaris.common.utils.Utils;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import io.netty.buffer.Unpooled;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class PlanetUtil {
    public static final ResourceLocation TEXTURE = ResourceLocationUtils.texture("planet_bar/earth_planet_bar");
    public static final Component temperature = Component.translatable((String)"text.stellaris.planetscreen.temperature");
    public static final Component gravity = Component.translatable((String)"text.stellaris.planetscreen.gravity");
    public static final Component launch = Component.translatable((String)"text.stellaris.planetscreen.launch");
    public static final Component oxygen = Component.translatable((String)"text.stellaris.planetscreen.oxygen");
    public static final Component system = Component.translatable((String)"text.stellaris.planetscreen.system");
    public static final Component error_message = Component.translatable((String)"text.stellaris.planetscreen.error_message");

    public static Planet getPlanet(ResourceLocation level) {
        AtomicReference p = new AtomicReference();
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.dimension().equals((Object)level)) {
                p.set(planet);
            }
        });
        return (Planet)p.get();
    }

    public static Planet getPlanetFromOrbit(ResourceLocation orbit) {
        AtomicReference p = new AtomicReference();
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.orbit().isPresent() && planet.orbit().get().equals((Object)orbit)) {
                p.set(planet);
            }
        });
        return (Planet)p.get();
    }

    public static boolean isPlanet(ResourceLocation level) {
        AtomicBoolean isPlanet = new AtomicBoolean(false);
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.dimension().equals((Object)level)) {
                isPlanet.set(true);
            }
        });
        return isPlanet.get();
    }

    public static boolean isOrbit(ResourceLocation level) {
        AtomicBoolean isOrbit = new AtomicBoolean(false);
        StellarisData.getPlanets().forEach(planet -> {
            if (planet.orbit().isPresent() && planet.orbit().get().equals((Object)level)) {
                isOrbit.set(true);
            }
        });
        return isOrbit.get();
    }

    public static void ifPlanet(ResourceLocation level, Consumer<Planet> planetRunnable) {
        if (PlanetUtil.isPlanet(level)) {
            planetRunnable.accept(PlanetUtil.getPlanet(level));
        }
    }

    public static boolean hasOxygen(Level level) {
        return !PlanetUtil.isPlanet(level.dimension().location()) || PlanetUtil.getPlanet(level.dimension().location()).oxygen();
    }

    public static boolean hasOxygenAt(ServerLevel level, @NotNull BlockPos pos) {
        if (!PlanetUtil.hasOxygen((Level)level)) {
            return GlobalOxygenManager.getInstance().getOrCreateDimensionManager(level).hasOxygenAt(pos);
        }
        return true;
    }

    public static ResourceLocation getSpaceStationDimension(Planet planet) {
        return planet.orbit().isPresent() ? planet.orbit().get() : planet.dimension();
    }

    public static ResourceLocation getPlanetBar(ResourceLocation level) {
        if (PlanetUtil.isPlanet(level)) {
            return PlanetUtil.getPlanet(level).textures().planet_bar();
        }
        return ResourceLocation.fromNamespaceAndPath((String)"stellaris", (String)"textures/planet_bar/earth_planet_bar.png");
    }

    public static int openPlanetSelectionMenu(Player player, final boolean forceCanGoTo, final String galaxyId) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buffer) {
                buffer.writeBoolean(forceCanGoTo);
                buffer.writeUtf(galaxyId);
            }

            public Component getDisplayName() {
                return Component.literal((String)"Planets");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new PlanetSelectionMenu(syncId, inv, forceCanGoTo, galaxyId);
            }

            public static PlanetSelectionMenu create(int syncId, Inventory inventory, FriendlyByteBuf data) {
                boolean forceCanGoTo2 = data.readBoolean();
                String galaxyId2 = data.readUtf();
                return new PlanetSelectionMenu(syncId, inventory, forceCanGoTo2, galaxyId2);
            }
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openWaitMenu(Player player, final String playerChoosing) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buffer) {
                buffer.writeUtf(playerChoosing);
            }

            @NotNull
            public Component getDisplayName() {
                return Component.literal((String)"Waiting");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                return WaitMenu.create(syncId, inv, buffer.writeUtf(playerChoosing));
            }
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openTabletMenu(Player player, final ResourceLocation entry) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buffer) {
                buffer.writeResourceLocation(entry);
            }

            public Component getDisplayName() {
                return Component.literal((String)"Tablet");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                buffer.writeResourceLocation(entry);
                return TabletMenu.create(syncId, inv, buffer);
            }
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static int openMilkyWayMenu(Player player) {
        ExtendedMenuProvider provider = new ExtendedMenuProvider(){

            public void saveExtraData(FriendlyByteBuf buf) {
            }

            public Component getDisplayName() {
                return Component.literal((String)"MilkyWay");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
                return GalaxyMenu.create(syncId, inv, buffer);
            }
        };
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MenuRegistry.openExtendedMenu((ServerPlayer)serverPlayer, (ExtendedMenuProvider)provider);
            return 1;
        }
        return 0;
    }

    public static MutableComponent[] getPlanetInfo(Planet planet) {
        MutableComponent temperatureV = Component.literal((String)(temperature.getString() + " : " + (int)planet.temperature() + "\u00b0C"));
        MutableComponent oxygenV = Component.literal((String)oxygen.getString());
        String gravityValue = String.valueOf(planet.gravity());
        if (gravityValue.length() > 4) {
            gravityValue = gravityValue.substring(0, 4);
        }
        MutableComponent gravityV = Component.literal((String)(gravity.getString() + " : " + gravityValue + "m/s"));
        MutableComponent systemV = Component.literal((String)(system.getString() + " : " + Component.translatable((String)planet.system()).getString()));
        if (planet.oxygen()) {
            oxygenV.withColor(Utils.getColorHexCode("Lime"));
        } else {
            oxygenV.withColor(Utils.getColorHexCode("Red"));
        }
        if (planet.temperature() >= 100.0f) {
            temperatureV.withColor(Utils.getColorHexCode("DarkRed"));
        } else if (planet.temperature() >= 0.0f) {
            temperatureV.withColor(Utils.getColorHexCode("Lime"));
        } else if (planet.temperature() >= -100.0f) {
            temperatureV.withColor(Utils.getColorHexCode("Cyan"));
        } else {
            temperatureV.withColor(Utils.getColorHexCode("Blue"));
        }
        return new MutableComponent[]{temperatureV, oxygenV, gravityV, systemV};
    }

    public static MutableComponent getInLinePlanetInfo(Planet planet) {
        MutableComponent[] component = PlanetUtil.getPlanetInfo(planet);
        return Component.literal((String)"").append((Component)component[0]).append(" | ").append((Component)component[1]).append(" | ").append((Component)component[2]);
    }
}

